<?php
date_default_timezone_set('America/Lima');

function fechaActual($tipo){
	// Obtenemos y traducimos el nombre del da
	$dia=date("l");
	if ($dia=="Monday") $dia="Lunes";
	if ($dia=="Tuesday") $dia="Martes";
	if ($dia=="Wednesday") $dia=utf8_encode("Mircoles");
	if ($dia=="Thursday") $dia="Jueves";
	if ($dia=="Friday") $dia="Viernes";
	if ($dia=="Saturday") $dia=utf8_encode("Sbado");
	if ($dia=="Sunday") $dia="Domingo";

		// Obtenemos el nmero del da
	$dia2=date("d");

		// Obtenemos y traducimos el nombre del mes
	$mes=date("F");
	if ($mes=="January") $mes="Enero";
	if ($mes=="February") $mes="Febrero";
	if ($mes=="March") $mes="Marzo";
	if ($mes=="April") $mes="Abril";
	if ($mes=="May") $mes="Mayo";
	if ($mes=="June") $mes="Junio";
	if ($mes=="July") $mes="Julio";
	if ($mes=="August") $mes="Agosto";
	if ($mes=="September") $mes="Setiembre";
	if ($mes=="October") $mes="Octubre";
	if ($mes=="November") $mes="Noviembre";
	if ($mes=="December") $mes="Diciembre";

		// Obtenemos el ao
	$ano=date("Y");

	switch ($tipo) {
		case 1:
		return $fecha="$dia, $dia2 de $mes del $ano";
		break;
		case 2:
		return $fecha="$dia2 de $mes del $ano";
		break;
	}
}

function calcula_numero_dia_semana($dia,$mes,$ano){ 
	$numerodiasemana = date('w', mktime(0,0,0,$mes,$dia,$ano)); 
	if ($numerodiasemana == 0) 
		$numerodiasemana = 6; 
	else 
		$numerodiasemana--; 
	return $numerodiasemana;	
}

function ultimoDia($mes,$ano){ 
	$ultimo_dia=28; 
	while (checkdate($mes,$ultimo_dia + 1,$ano)){ 
		$ultimo_dia++; 
	} 
	return $ultimo_dia; 
} 

function nombre_mes($mes){ 
	switch ($mes){ 
		case 1: 
		$nombre_mes="Enero"; 
		break; 
		case 2: 
		$nombre_mes="Febrero"; 
		break; 
		case 3: 
		$nombre_mes="Marzo"; 
		break; 
		case 4: 
		$nombre_mes="Abril"; 
		break; 
		case 5: 
		$nombre_mes="Mayo"; 
		break; 
		case 6: 
		$nombre_mes="Junio"; 
		break; 
		case 7: 
		$nombre_mes="Julio"; 
		break; 
		case 8: 
		$nombre_mes="Agosto"; 
		break; 
		case 9: 
		$nombre_mes="Septiembre"; 
		break; 
		case 10: 
		$nombre_mes="Octubre"; 
		break; 
		case 11: 
		$nombre_mes="Noviembre"; 
		break; 
		case 12: 
		$nombre_mes="Diciembre"; 
		break; 
	} 
	return $nombre_mes; 
}

function nombre_dia($fecha){
		//$fecha = "05-08-2004"; //5 agosto de 2004 por ejemplo  
		$fechats = strtotime($fecha); //a timestamp 
		//el parametro w en la funcion date indica que queremos el dia de la semana 
		//lo devuelve en numero 0 domingo, 1 lunes,.... 
		switch (date('w', $fechats)){ 
			case 0: $dia= "DOMINGO"; break; 
			case 1: $dia= "LUNES"; break; 
			case 2: $dia= "MARTES"; break; 
			case 3: $dia= "MIERCOLES"; break; 
			case 4: $dia= "JUEVES"; break; 
			case 5: $dia= "VIERNES"; break; 
			case 6: $dia= "SABADO"; break; 
		}
		return $dia;
	}
	
function dias_transcurridos($fecha_i,$fecha_f)
{
	$dias	= (strtotime($fecha_i)-strtotime($fecha_f))/86400;
	$dias 	= $dias; 
	$dias = $dias;		
	return $dias;
}

	function restaFechas($dFecIni, $dFecFin)
	{
		$dFecIni = str_replace("-","",$dFecIni);
		$dFecIni = str_replace("/","",$dFecIni);
		$dFecFin = str_replace("-","",$dFecFin);
		$dFecFin = str_replace("/","",$dFecFin);

		ereg( "([0-9]{1,2})([0-9]{1,2})([0-9]{2,4})", $dFecIni, $aFecIni);
		ereg( "([0-9]{1,2})([0-9]{1,2})([0-9]{2,4})", $dFecFin, $aFecFin);

		$date1 = mktime(0,0,0,$aFecIni[2], $aFecIni[1], $aFecIni[3]);
		$date2 = mktime(0,0,0,$aFecFin[2], $aFecFin[1], $aFecFin[3]);

		return round(($date2 - $date1) / (60 * 60 * 24));
	}

	function edad($fecha_nac){
		if(!empty($fecha_nac))
		{
			if($fecha_nac!='0000-00-00'){
				$dia=date("j");
				$mes=date("n");
				$anno=date("Y");

				//descomponer fecha de nacimiento
				/*$dia_nac=substr($fecha_nac, 8, 2);
				$mes_nac=substr($fecha_nac, 5, 2);
				$anno_nac=substr($fecha_nac, 0, 4);*/
				
				$dia_nac=date('d', strtotime($fecha_nac));
				$mes_nac=date('m', strtotime($fecha_nac));
				$anno_nac=date('Y', strtotime($fecha_nac));

				if($mes_nac>$mes){
					$calc_edad= $anno-$anno_nac-1;
				}else{
					if($mes==$mes_nac and $dia_nac>$dia){
						$calc_edad= $anno-$anno_nac-1;  
					}else{
						$calc_edad= $anno-$anno_nac;
					}
				}
			//
				//$fecha	=date('d-m-Y h:i:s a', strtotime($fec));
			}
			else
			{
				$calc_edad="";
			}
		}
		else
		{
			$calc_edad="";
		}

		return $calc_edad;
	}

	function comparar_fechavencimiento($fecha){
		$fechahoy = fecha_mysql(date('d-m-Y'));
		$fechacomparar = fecha_mysql($fecha);

		if($fechahoy > $fechacomparar){
			if($fecha=='0000-00-00'){
				return array('warning','ERROR FECHA VENC.!');
			}else{

				return array('danger','VENCIDO'); 
			}
		}elseif($fechahoy < $fechacomparar){  
			return array('success','POR VENCER');
		}
		elseif($fechahoy == $fechacomparar){
			return array('success','VENCE HOY'); 
		}else{
			return array('warning','ERROR!');
		}
	}

	function fecha_entexto($date)
	{
		$dia = explode("-", $date, 3);
		$year = $dia[0];
		$month = (string)(int)$dia[1];
		$day = (string)(int)$dia[2];

		$dias = array("domingo","lunes","martes","mi&eacute;rcoles" ,"jueves","viernes","s&aacute;bado");
		$tomadia = $dias[intval((date("w",mktime(0,0,0,$month,$day,$year))))];

		$meses = array("", "enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre");

	    //return $tomadia.", ".$day." de ".$meses[$month]." de ".$year;
		return $day." de ".$meses[$month]." del ".$year;
	}
	
	
function fecha_entexto_corto($date,$tipo) { //tipo 1 MAYUSCULAS 2 MINUSCULAS |resulta 30 - MAR - 2018 
		$dia = explode("-", $date, 3);
		$year = $dia[0];
		$month = (string)(int)$dia[1];
		$day = (string)(int)$dia[2];
		$dias = array("domingo","lunes","martes","mi&eacute;rcoles" ,"jueves","viernes","s&aacute;bado");
		$tomadia = $dias[intval((date("w",mktime(0,0,0,$month,$day,$year))))];
		if($tipo=='1'){
			$meses = array("", "ENE", "FEB", "MAR", "ABR", "MAY", "JUN", "JUL", "AGO", "SEP", "OCT", "NOV", "DIC");
		}else{
			$meses = array("", "Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic");
		}
		return $day." - ".$meses[$month]." - ".$year;
	}

	
	
	?>